/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.model;

import java.awt.Color;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.Entity;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextComponentTranslation;
import noppes.npcs.CustomNpcs;
import noppes.npcs.ModelPartData;
import noppes.npcs.client.Client;
import noppes.npcs.client.gui.model.GuiCreationExtra;
import noppes.npcs.client.gui.model.GuiCreationScreenInterface;
import noppes.npcs.client.gui.model.GuiModelColor;
import noppes.npcs.client.gui.select.GuiTextureSelection;
import noppes.npcs.client.gui.util.GuiButtonBiDirectional;
import noppes.npcs.client.gui.util.GuiColorButton;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiNPCInterface;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcButtonYesNo;
import noppes.npcs.client.gui.util.GuiNpcCheckBox;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.GuiNpcSlider;
import noppes.npcs.client.gui.util.GuiNpcTextField;
import noppes.npcs.client.gui.util.ICustomScrollListener;
import noppes.npcs.client.gui.util.IGuiCustomScroll;
import noppes.npcs.client.gui.util.IGuiNpcButton;
import noppes.npcs.client.gui.util.IGuiNpcLabel;
import noppes.npcs.client.gui.util.IGuiNpcSlider;
import noppes.npcs.client.gui.util.IGuiNpcTextField;
import noppes.npcs.client.gui.util.ISliderListener;
import noppes.npcs.client.gui.util.ISubGuiListener;
import noppes.npcs.client.gui.util.ITextfieldListener;
import noppes.npcs.client.gui.util.SubGuiInterface;
import noppes.npcs.client.model.part.LayerModel;
import noppes.npcs.client.model.part.ModelEyeData;
import noppes.npcs.client.renderer.RenderCustomNpc;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.constants.EnumParts;
import noppes.npcs.containers.ContainerLayer;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.util.CustomNPCsScheduler;
import noppes.npcs.util.ValueUtil;
import org.lwjgl.input.Keyboard;

public class GuiCreationParts
extends GuiCreationScreenInterface
implements ITextfieldListener,
ICustomScrollListener,
ISubGuiListener,
ISliderListener {
    private static final DecimalFormat df = new DecimalFormat("#.####");
    private static int selected = 0;
    private final GuiPart[] parts = new GuiPart[]{new GuiPart(EnumParts.EARS).setTypes(new String[]{"gui.none", "gui.normal", "ears.bunny"}), new GuiPartHorns(), new GuiPartHair(), new GuiPart(EnumParts.MOHAWK).setTypes(new String[]{"gui.none", "1", "2"}).noPlayerOptions(), new GuiPartSnout(), new GuiPartBeard(), new GuiPart(EnumParts.FIN).setTypes(new String[]{"gui.none", "fin.shark", "fin.reptile"}), new GuiPart(EnumParts.BREASTS).setTypes(new String[]{"gui.none", "1", "2", "3"}).noPlayerOptions(), new GuiPartWings(), new GuiPartClaws(), new GuiPart(EnumParts.SKIRT).setTypes(new String[]{"gui.none", "gui.normal"}), new GuiPartLegs(), new GuiPartTail(), new GuiPartEyes(), new GuiPartParticles(), new GuiPartLayers(this)};
    private GuiCustomScroll scroll;
    private boolean isCheck = false;
    private int waitKey;
    private int waitKeyID;
    private int toolType;

    public GuiCreationParts(EntityNPCInterface npc, ContainerLayer container) {
        super(npc, container);
        this.active = 2;
        this.closeOnEsc = false;
        Arrays.sort(this.parts, (o1, o2) -> {
            String s1 = new TextComponentTranslation("part." + o1.part.name, new Object[0]).func_150254_d();
            String s2 = new TextComponentTranslation("part." + o2.part.name, new Object[0]).func_150254_d();
            return s1.compareToIgnoreCase(s2);
        });
    }

    @Override
    protected void func_146284_a(@Nonnull GuiButton btn) {
        super.func_146284_a(btn);
        if (this.getPart() != null) {
            this.getPart().actionPerformed(btn);
        }
    }

    protected GuiPart getPart() {
        return this.parts[selected];
    }

    @Override
    public void func_146276_q_() {
        super.func_146276_q_();
        GuiPart part = this.getPart();
        if (part instanceof GuiPartLayers && ((GuiPartLayers)part).isCustomLayers) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)((float)this.field_147003_i + 121.0f), (float)((float)this.field_147009_r + 163.0f), (float)0.0f);
            this.field_146297_k.func_110434_K().func_110577_a(GuiNPCInterface.RESOURCE_SLOT);
            for (Slot slot : ((GuiPartLayers)((GuiPartLayers)part)).cont.field_75151_b) {
                int y;
                int x;
                if (slot.field_75222_d == 0) {
                    x = 164;
                    y = 0;
                } else {
                    x = (slot.field_75222_d - 1) % 9 * 18;
                    y = (slot.field_75222_d - 1) / 9 * 18;
                }
                this.func_73729_b(x, y, 0, 0, 18, 18);
            }
            GlStateManager.func_179121_F();
        }
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        block7: {
            block16: {
                block38: {
                    block37: {
                        block36: {
                            block35: {
                                block34: {
                                    block33: {
                                        block32: {
                                            block31: {
                                                block30: {
                                                    block29: {
                                                        block28: {
                                                            block27: {
                                                                block26: {
                                                                    block25: {
                                                                        block24: {
                                                                            block23: {
                                                                                block22: {
                                                                                    block21: {
                                                                                        block20: {
                                                                                            block19: {
                                                                                                block18: {
                                                                                                    block17: {
                                                                                                        block15: {
                                                                                                            block14: {
                                                                                                                block13: {
                                                                                                                    block12: {
                                                                                                                        block11: {
                                                                                                                            block10: {
                                                                                                                                block9: {
                                                                                                                                    block8: {
                                                                                                                                        block6: {
                                                                                                                                            super.func_73863_a(mouseX, mouseY, partialTicks);
                                                                                                                                            if (this.waitKey != 0) {
                                                                                                                                                --this.waitKey;
                                                                                                                                            }
                                                                                                                                            GuiPart part = this.getPart();
                                                                                                                                            if (!this.isCheck && part instanceof GuiPartLayers && this.getButton(21) != null) {
                                                                                                                                                CustomNPCsScheduler.runTack(() -> {
                                                                                                                                                    this.isCheck = true;
                                                                                                                                                    this.getButton(21).setEnabled(this.playerdata.isNoEmptyLayer());
                                                                                                                                                    LayerModel lm = this.playerdata.getLayerModel(((GuiPartLayers)this.getPart()).selectPos);
                                                                                                                                                    GuiCustomScroll scrollIn = ((GuiPartLayers)part).scrollIn;
                                                                                                                                                    ItemStack stack = ((GuiPartLayers)part).cont.func_75139_a(0).func_75211_c();
                                                                                                                                                    if (lm == null) {
                                                                                                                                                        if (scrollIn.hasSelected() || !stack.func_190926_b()) {
                                                                                                                                                            this.func_73866_w_();
                                                                                                                                                        }
                                                                                                                                                    } else if (lm.getStack() != stack) {
                                                                                                                                                        lm.setStack(((GuiPartLayers)part).cont.func_75139_a(0).func_75211_c());
                                                                                                                                                        this.func_73866_w_();
                                                                                                                                                    }
                                                                                                                                                    this.isCheck = false;
                                                                                                                                                });
                                                                                                                                            }
                                                                                                                                            if (this.subgui != null || !CustomNpcs.ShowDescriptions) {
                                                                                                                                                return;
                                                                                                                                            }
                                                                                                                                            if (this.getButton(1) == null || !this.getButton(1).isHovered()) break block6;
                                                                                                                                            this.setHoverText(new TextComponentTranslation("display.hover.part.entity", new Object[0]).func_150254_d(), new Object[0]);
                                                                                                                                            break block7;
                                                                                                                                        }
                                                                                                                                        if (this.getButton(2) == null || !this.getButton(2).isHovered()) break block8;
                                                                                                                                        this.setHoverText(new TextComponentTranslation("display.hover.parts", new Object[0]).func_150254_d(), new Object[0]);
                                                                                                                                        break block7;
                                                                                                                                    }
                                                                                                                                    if (this.getButton(3) == null || !this.getButton(3).isHovered()) break block9;
                                                                                                                                    this.setHoverText(new TextComponentTranslation("display.hover.part.size", new Object[0]).func_150254_d(), new Object[0]);
                                                                                                                                    break block7;
                                                                                                                                }
                                                                                                                                if (this.getButton(4) == null || !this.getButton(4).isHovered()) break block10;
                                                                                                                                this.setHoverText(new TextComponentTranslation("display.hover.part.save", new Object[0]).func_150254_d(), new Object[0]);
                                                                                                                                break block7;
                                                                                                                            }
                                                                                                                            if (this.getButton(5) == null || !this.getButton(5).isHovered()) break block11;
                                                                                                                            this.setHoverText(new TextComponentTranslation("display.hover.part.load", new Object[0]).func_150254_d(), new Object[0]);
                                                                                                                            break block7;
                                                                                                                        }
                                                                                                                        if (this.getButton(20) == null || !this.getButton(20).isHovered()) break block12;
                                                                                                                        if (!(this.getPart() instanceof GuiPartLayers)) {
                                                                                                                            this.setHoverText(new TextComponentTranslation("display.hover.part.type", new Object[0]).func_150254_d(), new Object[0]);
                                                                                                                        }
                                                                                                                        break block7;
                                                                                                                    }
                                                                                                                    if (this.getButton(21) == null || !this.getButton(21).isHovered()) break block13;
                                                                                                                    this.setHoverText(new TextComponentTranslation("display.hover.part.skin", new Object[0]).func_150254_d(), new Object[0]);
                                                                                                                    break block7;
                                                                                                                }
                                                                                                                if (this.getButton(22) == null || !this.getButton(22).isHovered()) break block14;
                                                                                                                this.setHoverText(new TextComponentTranslation("display.hover.part.pattern", new Object[0]).func_150254_d(), new Object[0]);
                                                                                                                break block7;
                                                                                                            }
                                                                                                            if (this.getButton(66) == null || !this.getButton(66).isHovered()) break block15;
                                                                                                            this.setHoverText(new TextComponentTranslation("hover.back", new Object[0]).func_150254_d(), new Object[0]);
                                                                                                            break block7;
                                                                                                        }
                                                                                                        if (!(this.getPart() instanceof GuiPartEyes)) break block16;
                                                                                                        if (this.getButton(23) == null || !this.getButton(23).isVisible() || !this.isMouseHover(mouseX, mouseY, this.getButton(23).getLeft(), this.getButton(23).getTop(), this.getButton(23).getWidth(), this.getButton(23).getHeight())) break block17;
                                                                                                        this.setHoverText(new TextComponentTranslation("display.hover.part.eye.color.r", new Object[0]).func_150254_d(), new Object[0]);
                                                                                                        break block7;
                                                                                                    }
                                                                                                    if (this.getButton(24) == null || !this.getButton(24).isVisible() || !this.isMouseHover(mouseX, mouseY, this.getButton(24).getLeft(), this.getButton(24).getTop(), this.getButton(24).getWidth(), this.getButton(24).getHeight())) break block18;
                                                                                                    this.setHoverText(new TextComponentTranslation("display.hover.part.eye.color.l", new Object[0]).func_150254_d(), new Object[0]);
                                                                                                    break block7;
                                                                                                }
                                                                                                if (this.getButton(25) == null || !this.getButton(25).isVisible() || !this.isMouseHover(mouseX, mouseY, this.getButton(25).getLeft(), this.getButton(25).getTop(), this.getButton(25).getWidth(), this.getButton(25).getHeight())) break block19;
                                                                                                this.setHoverText(new TextComponentTranslation("display.hover.part.pupil.color.r", new Object[0]).func_150254_d(), new Object[0]);
                                                                                                break block7;
                                                                                            }
                                                                                            if (this.getButton(26) == null || !this.getButton(26).isVisible() || !this.isMouseHover(mouseX, mouseY, this.getButton(26).getLeft(), this.getButton(26).getTop(), this.getButton(26).getWidth(), this.getButton(26).getHeight())) break block20;
                                                                                            this.setHoverText(new TextComponentTranslation("display.hover.part.pupil.color.l", new Object[0]).func_150254_d(), new Object[0]);
                                                                                            break block7;
                                                                                        }
                                                                                        if (this.getButton(27) == null || !this.getButton(27).isVisible() || !this.isMouseHover(mouseX, mouseY, this.getButton(27).getLeft(), this.getButton(27).getTop(), this.getButton(27).getWidth(), this.getButton(27).getHeight())) break block21;
                                                                                        this.setHoverText(new TextComponentTranslation("display.hover.part.brow.color.r", new Object[0]).func_150254_d(), new Object[0]);
                                                                                        break block7;
                                                                                    }
                                                                                    if (this.getButton(28) == null || !this.getButton(28).isVisible() || !this.isMouseHover(mouseX, mouseY, this.getButton(28).getLeft(), this.getButton(28).getTop(), this.getButton(28).getWidth(), this.getButton(28).getHeight())) break block22;
                                                                                    this.setHoverText(new TextComponentTranslation("display.hover.part.brow.color.l", new Object[0]).func_150254_d(), new Object[0]);
                                                                                    break block7;
                                                                                }
                                                                                if (this.getButton(29) == null || !this.getButton(29).isHovered()) break block23;
                                                                                this.setHoverText(new TextComponentTranslation("display.hover.part.brow.size", new Object[0]).func_150254_d(), new Object[0]);
                                                                                break block7;
                                                                            }
                                                                            if (this.getButton(30) == null || !this.getButton(30).isVisible() || !this.isMouseHover(mouseX, mouseY, this.getButton(30).getLeft(), this.getButton(30).getTop(), this.getButton(30).getWidth(), this.getButton(30).getHeight())) break block24;
                                                                            this.setHoverText(new TextComponentTranslation("display.hover.part.skin.color", new Object[0]).func_150254_d(), new Object[0]);
                                                                            break block7;
                                                                        }
                                                                        if (this.getButton(31) == null || !this.getButton(31).isHovered()) break block25;
                                                                        this.setHoverText(new TextComponentTranslation("display.hover.part.closed", new Object[0]).func_150254_d(), new Object[0]);
                                                                        break block7;
                                                                    }
                                                                    if (this.getButton(32) == null || !this.getButton(32).isHovered()) break block26;
                                                                    this.setHoverText(new TextComponentTranslation("display.hover.part.pos", new Object[0]).func_150254_d(), new Object[0]);
                                                                    break block7;
                                                                }
                                                                if (this.getButton(33) == null || !this.getButton(33).isHovered()) break block27;
                                                                this.setHoverText(new TextComponentTranslation("display.hover.part.glint", new Object[0]).func_150254_d(), new Object[0]);
                                                                break block7;
                                                            }
                                                            if (this.getButton(34) == null || !this.getButton(34).isHovered()) break block28;
                                                            this.setHoverText(new TextComponentTranslation("display.hover.part.eye.txr.r", new Object[0]).func_150254_d(), new Object[0]);
                                                            break block7;
                                                        }
                                                        if (this.getButton(35) == null || !this.getButton(35).isHovered()) break block29;
                                                        this.setHoverText(new TextComponentTranslation("display.hover.part.eye.txr.l", new Object[0]).func_150254_d(), new Object[0]);
                                                        break block7;
                                                    }
                                                    if (this.getButton(36) == null || !this.getButton(36).isHovered()) break block30;
                                                    this.setHoverText(new TextComponentTranslation("display.hover.part.pupil.txr.r", new Object[0]).func_150254_d(), new Object[0]);
                                                    break block7;
                                                }
                                                if (this.getButton(37) == null || !this.getButton(37).isHovered()) break block31;
                                                this.setHoverText(new TextComponentTranslation("display.hover.part.pupil.txr.l", new Object[0]).func_150254_d(), new Object[0]);
                                                break block7;
                                            }
                                            if (this.getButton(38) == null || !this.getButton(38).isHovered()) break block32;
                                            this.setHoverText(new TextComponentTranslation("display.hover.part.brow.txr.r", new Object[0]).func_150254_d(), new Object[0]);
                                            break block7;
                                        }
                                        if (this.getButton(39) == null || !this.getButton(39).isHovered()) break block33;
                                        this.setHoverText(new TextComponentTranslation("display.hover.part.brow.txr.l", new Object[0]).func_150254_d(), new Object[0]);
                                        break block7;
                                    }
                                    if (this.getButton(40) == null || !this.getButton(40).isHovered()) break block34;
                                    this.setHoverText(new TextComponentTranslation("display.hover.part.rnd", new Object[0]).func_150254_d(), new Object[0]);
                                    break block7;
                                }
                                if ((this.getButton(41) == null || !this.getButton(41).isHovered()) && (this.getButton(42) == null || !this.getButton(42).isHovered())) break block35;
                                this.setHoverText(new TextComponentTranslation("display.hover.part.eye.active", new Object[0]).func_150254_d(), new Object[0]);
                                break block7;
                            }
                            if (this.getButton(43) == null || !this.getButton(43).isHovered()) break block36;
                            this.setHoverText(new TextComponentTranslation("display.hover.part.center.active", new Object[0]).func_150254_d(), new Object[0]);
                            break block7;
                        }
                        if (this.getButton(45) == null || !this.getButton(45).isVisible() || !this.isMouseHover(mouseX, mouseY, this.getButton(45).getLeft(), this.getButton(45).getTop(), this.getButton(45).getWidth(), this.getButton(45).getHeight())) break block37;
                        this.setHoverText(new TextComponentTranslation("display.hover.part.eye.color", new Object[0]).func_150254_d(), new Object[0]);
                        break block7;
                    }
                    if (this.getButton(46) == null || !this.getButton(46).isVisible() || !this.isMouseHover(mouseX, mouseY, this.getButton(46).getLeft(), this.getButton(46).getTop(), this.getButton(46).getWidth(), this.getButton(46).getHeight())) break block38;
                    this.setHoverText(new TextComponentTranslation("display.hover.part.pupil.color", new Object[0]).func_150254_d(), new Object[0]);
                    break block7;
                }
                if (this.getButton(47) == null || !this.getButton(47).isVisible() || !this.isMouseHover(mouseX, mouseY, this.getButton(47).getLeft(), this.getButton(47).getTop(), this.getButton(47).getWidth(), this.getButton(47).getHeight())) break block7;
                this.setHoverText(new TextComponentTranslation("display.hover.part.brow.color", new Object[0]).func_150254_d(), new Object[0]);
                break block7;
            }
            if (this.getButton(23) != null && this.getButton(23).isVisible() && this.isMouseHover(mouseX, mouseY, this.getButton(23).getLeft(), this.getButton(23).getTop(), this.getButton(23).getWidth(), this.getButton(23).getHeight())) {
                this.setHoverText(new TextComponentTranslation("display.hover.part.color", new Object[0]).func_150254_d(), new Object[0]);
                return;
            }
            for (GuiButton b : this.field_146292_n) {
                if (b == null || !b.func_146115_a() || b.field_146127_k != 500) continue;
                this.setHoverText(new TextComponentTranslation("display.hover.part.rotate", new Object[0]).func_150254_d(), new Object[0]);
            }
        }
        this.drawHoverText(null, new Object[0]);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.entity != null) {
            this.openGui((GuiScreen)new GuiCreationExtra(this.npc, (ContainerLayer)this.field_147002_h));
            return;
        }
        if (this.scroll == null) {
            ArrayList<String> list = new ArrayList<String>();
            for (GuiPart part : this.parts) {
                list.add(new TextComponentTranslation("part." + part.part.name, new Object[0]).func_150254_d());
            }
            this.scroll = new GuiCustomScroll(this, 0);
            this.scroll.setListNotSorted(list);
        }
        this.scroll.guiLeft = this.field_147003_i;
        this.scroll.guiTop = this.field_147009_r + 46;
        this.scroll.setSize(121, this.field_147000_g - 74);
        this.addScroll(this.scroll);
        if (this.getPart() != null) {
            this.scroll.setSelected(new TextComponentTranslation("part." + this.getPart().part.name, new Object[0]).func_150254_d());
            this.getPart().initGui();
        }
        if (this.field_147002_h instanceof ContainerLayer) {
            boolean bo = this.getPart() instanceof GuiPartLayers && ((GuiPartLayers)this.getPart()).isCustomLayers;
            for (Slot slot : this.field_147002_h.field_75151_b) {
                int y;
                int x;
                if (slot.field_75222_d == 0) {
                    x = 164;
                    y = 0;
                } else {
                    x = (slot.field_75222_d - 1) % 9 * 18;
                    y = (slot.field_75222_d - 1) / 9 * 18;
                    if (slot.field_75222_d - 1 < 9) {
                        y += 54;
                    } else if (slot.field_75222_d - 1 != 36) {
                        y -= 18;
                    }
                }
                slot.field_75223_e = bo ? 122 + x : -5000;
                slot.field_75221_f = bo ? 164 + y : -5000;
            }
        }
    }

    @Override
    public void scrollClicked(int mouseX, int mouseY, int mouseButton, IGuiCustomScroll scroll) {
        if (scroll.getID() == 0 && scroll.getSelect() >= 0) {
            selected = scroll.getSelect();
            this.func_73866_w_();
        }
        if (scroll.getID() == 1 && this.getPart() instanceof GuiPartLayers) {
            GuiPartLayers part = (GuiPartLayers)this.getPart();
            if (part.isCustomLayers) {
                part.selectPos = scroll.getSelect();
                LayerModel lm = this.playerdata.getLayerModel(scroll.getSelect());
                if (lm == null) {
                    part.cont.func_75139_a(0).func_75215_d(ItemStack.field_190927_a);
                } else {
                    part.cont.func_75139_a(0).func_75215_d(lm.getStack());
                }
            } else {
                this.playerdata.setDisableLayers(scroll.getSelectedList().toArray(new String[0]));
            }
            part.initGui();
        }
    }

    @Override
    public void scrollDoubleClicked(String selection, IGuiCustomScroll scroll) {
    }

    @Override
    public void subGuiClosed(SubGuiInterface subgui) {
        if (this.getPart() != null) {
            this.getPart().subGuiClosed(subgui);
        }
        this.func_73866_w_();
    }

    @Override
    public void func_73869_a(char c, int i) {
        if (this.subgui == null && this.getPart() instanceof GuiPartLayers) {
            if (this.isPressAndKey(16) && this.toolType != 1) {
                this.toolType = 1;
                this.playButtonClick();
                this.func_73866_w_();
            }
            if (this.isPressAndKey(17) && this.toolType != 0) {
                this.toolType = 0;
                this.playButtonClick();
                this.func_73866_w_();
            }
            if (this.isPressAndKey(18) && this.toolType != 2) {
                this.toolType = 2;
                this.playButtonClick();
                this.func_73866_w_();
            }
        }
        super.func_73869_a(c, i);
    }

    private void playButtonClick() {
        this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
    }

    private boolean isPressAndKey(int id) {
        boolean isPress;
        if (this.waitKey > 0 && this.waitKeyID == id) {
            return false;
        }
        boolean bl = isPress = GuiCreationParts.func_175283_s() && Keyboard.isKeyDown((int)id);
        if (isPress) {
            this.waitKey = 30;
            this.waitKeyID = id;
        }
        return isPress;
    }

    @Override
    public void mouseDragged(IGuiNpcSlider slider) {
        if (this.getPart() instanceof GuiPartLayers) {
            switch (slider.getID()) {
                case 26: {
                    this.sliderMoved(0, slider.getSliderValue());
                    break;
                }
                case 27: {
                    this.sliderMoved(1, slider.getSliderValue());
                    break;
                }
                case 28: {
                    this.sliderMoved(2, slider.getSliderValue());
                    break;
                }
                default: {
                    super.mouseDragged(slider);
                }
            }
            if (this.showEntity instanceof EntityCustomNpc && this.playerdata != null) {
                ((EntityCustomNpc)this.showEntity).modelData.load(this.playerdata.save());
            }
            return;
        }
        super.mouseDragged(slider);
    }

    @Override
    public void mousePressed(IGuiNpcSlider slider) {
    }

    @Override
    public void mouseReleased(IGuiNpcSlider slider) {
    }

    @Override
    public void unFocused(IGuiNpcTextField textField) {
        if (this.getPart() instanceof GuiPartLayers) {
            switch (textField.getID()) {
                case 25: {
                    LayerModel lm = this.playerdata.getLayerModel(((GuiPartLayers)this.getPart()).selectPos);
                    if (lm == null) {
                        return;
                    }
                    lm.setOBJ(textField.getFullText());
                    if (lm.getOBJ() != null) {
                        textField.setFullText(lm.getOBJ().toString());
                    }
                    this.getPart().initGui();
                    break;
                }
                case 26: {
                    textField.setFullText(this.textFieldChanged(0, (float)textField.getDouble()));
                    break;
                }
                case 27: {
                    textField.setFullText(this.textFieldChanged(1, (float)textField.getDouble()));
                    break;
                }
                case 28: {
                    textField.setFullText(this.textFieldChanged(2, (float)textField.getDouble()));
                }
            }
            if (this.showEntity instanceof EntityCustomNpc && this.playerdata != null) {
                ((EntityCustomNpc)this.showEntity).modelData.load(this.playerdata.save());
            }
            return;
        }
        super.unFocused(textField);
    }

    private void sliderMoved(int id, float sliderValue) {
        LayerModel lm = this.playerdata.getLayerModel(((GuiPartLayers)this.getPart()).selectPos);
        if (lm == null) {
            return;
        }
        switch (this.toolType) {
            case 0: {
                lm.rotation[id] = 360.0f * sliderValue - 180.0f;
                if (this.getTextField(26 + id) == null) break;
                this.getTextField(26 + id).setFullText(df.format(lm.rotation[id]));
                break;
            }
            case 1: {
                lm.offset[id] = 5.0f * sliderValue - 2.5f;
                if (this.getTextField(26 + id) == null) break;
                this.getTextField(26 + id).setFullText(df.format(lm.offset[id]));
                break;
            }
            default: {
                lm.scale[id] = 5.0f * sliderValue;
                if (this.getTextField(26 + id) == null) break;
                this.getTextField(26 + id).setFullText(df.format(lm.scale[id]));
            }
        }
    }

    private String textFieldChanged(int id, float textValue) {
        LayerModel lm = this.playerdata.getLayerModel(((GuiPartLayers)this.getPart()).selectPos);
        String text = "" + textValue;
        if (lm == null) {
            return text;
        }
        switch (this.toolType) {
            case 0: {
                while (textValue < -180.0f) {
                    textValue += 180.0f;
                }
                while (textValue > 180.0f) {
                    textValue -= 180.0f;
                }
                lm.rotation[id] = textValue;
                if (this.getSlider(26 + id) != null) {
                    this.getSlider(26 + id).setSliderValue(0.002778f * lm.rotation[id] + 0.5f);
                }
                text = df.format(lm.rotation[id]);
                break;
            }
            case 1: {
                lm.offset[id] = ValueUtil.correctFloat(textValue, -10.0f, 10.0f);
                if (this.getSlider(26 + id) != null) {
                    this.getSlider(26 + id).setSliderValue(0.2f * lm.offset[id] + 0.5f);
                }
                text = df.format(lm.offset[id]);
                break;
            }
            default: {
                lm.scale[id] = ValueUtil.correctFloat(textValue, 0.0f, 5.0f);
                if (this.getSlider(26 + id) != null) {
                    this.getSlider(26 + id).setSliderValue(0.2f * lm.scale[id]);
                }
                text = df.format(lm.scale[id]);
            }
        }
        return text;
    }

    private void resetAxis(int id) {
        LayerModel lm = this.playerdata.getLayerModel(((GuiPartLayers)this.getPart()).selectPos);
        if (lm == null) {
            return;
        }
        switch (this.toolType) {
            case 0: {
                lm.rotation[id] = 0.0f;
                if (this.getTextField(26 + id) != null) {
                    this.getTextField(26 + id).setFullText("0");
                }
                if (this.getSlider(26 + id) == null) break;
                this.getSlider(26 + id).setSliderValue(0.002778f * lm.rotation[id] + 0.5f);
                break;
            }
            case 1: {
                lm.offset[id] = 0.0f;
                if (this.getTextField(26 + id) != null) {
                    this.getTextField(26 + id).setFullText("0");
                }
                if (this.getSlider(26 + id) == null) break;
                this.getSlider(26 + id).setSliderValue(0.2f * lm.offset[id] + 0.5f);
                break;
            }
            default: {
                lm.scale[id] = 1.0f;
                if (this.getTextField(26 + id) != null) {
                    this.getTextField(26 + id).setFullText("1");
                }
                if (this.getSlider(26 + id) == null) break;
                this.getSlider(26 + id).setSliderValue(0.2f * lm.scale[id]);
            }
        }
    }

    class GuiPartLayers
    extends GuiPart {
        private final GuiCreationParts parent;
        private final ContainerLayer cont;
        public boolean isCustomLayers;
        public GuiCustomScroll scrollIn;
        public int selectPos;
        public Map<Integer, EnumParts> partNames;

        public GuiPartLayers(GuiCreationParts parentIn) {
            super(EnumParts.CUSTOM_LAYERS);
            this.isCustomLayers = false;
            this.selectPos = 0;
            this.partNames = new LinkedHashMap<Integer, EnumParts>();
            this.cont = (ContainerLayer)GuiCreationParts.this.field_147002_h;
            this.parent = parentIn;
            this.partNames.put(0, EnumParts.HEAD);
            this.partNames.put(1, EnumParts.BODY);
            this.partNames.put(2, EnumParts.ARM_RIGHT);
            this.partNames.put(3, EnumParts.ARM_LEFT);
            this.partNames.put(4, EnumParts.LEG_RIGHT);
            this.partNames.put(5, EnumParts.LEG_LEFT);
            this.partNames.put(6, EnumParts.BELT);
            this.partNames.put(7, EnumParts.WRIST_RIGHT);
            this.partNames.put(8, EnumParts.WRIST_LEFT);
            this.partNames.put(9, EnumParts.FOOT_RIGHT);
            this.partNames.put(10, EnumParts.FOOT_LEFT);
            LayerModel lm = GuiCreationParts.this.playerdata.getLayerModel(this.selectPos);
            if (lm != null) {
                Client.sendData(EnumPacketServer.ChangeItemInSlot, "ContainerLayer", 0, lm.getStack().func_77955_b(new NBTTagCompound()));
            }
        }

        @Override
        protected void actionPerformed(GuiButton btn) {
            switch (btn.field_146127_k) {
                case 20: {
                    this.isCustomLayers = ((GuiNpcCheckBox)btn).isSelected();
                    this.parent.func_73866_w_();
                    break;
                }
                case 21: {
                    if (this.cont == null) {
                        return;
                    }
                    this.selectPos = GuiCreationParts.this.playerdata.addNewLayer();
                    this.cont.func_75139_a(0).func_75215_d(ItemStack.field_190927_a);
                    Client.sendData(EnumPacketServer.ChangeItemInSlot, "ContainerLayer", 0, ItemStack.field_190927_a.func_77955_b(new NBTTagCompound()));
                    break;
                }
                case 22: {
                    this.selectPos = GuiCreationParts.this.playerdata.removeLayer(this.selectPos);
                    NBTTagCompound compound = new NBTTagCompound();
                    LayerModel lm = GuiCreationParts.this.playerdata.getLayerModel(this.selectPos);
                    if (lm == null) {
                        ItemStack.field_190927_a.func_77955_b(compound);
                        this.cont.func_75139_a(0).func_75215_d(ItemStack.field_190927_a);
                    } else {
                        lm.getStack().func_77955_b(compound);
                        this.cont.func_75139_a(0).func_75215_d(lm.getStack());
                    }
                    Client.sendData(EnumPacketServer.ChangeItemInSlot, "ContainerLayer", 0, compound);
                    this.initGui();
                    break;
                }
                case 23: {
                    if (GuiCreationParts.this.toolType == 1) {
                        return;
                    }
                    GuiNpcTextField.unfocus();
                    GuiCreationParts.this.toolType = 1;
                    this.parent.func_73866_w_();
                    break;
                }
                case 24: {
                    if (GuiCreationParts.this.toolType == 0) {
                        return;
                    }
                    GuiNpcTextField.unfocus();
                    GuiCreationParts.this.toolType = 0;
                    this.parent.func_73866_w_();
                    break;
                }
                case 25: {
                    if (GuiCreationParts.this.toolType == 2) {
                        return;
                    }
                    GuiNpcTextField.unfocus();
                    GuiCreationParts.this.toolType = 2;
                    this.parent.func_73866_w_();
                    break;
                }
                case 26: {
                    GuiCreationParts.this.resetAxis(0);
                    if (!(GuiCreationParts.this.showEntity instanceof EntityCustomNpc) || GuiCreationParts.this.playerdata == null) break;
                    ((EntityCustomNpc)GuiCreationParts.this.showEntity).modelData.load(GuiCreationParts.this.playerdata.save());
                    break;
                }
                case 27: {
                    GuiCreationParts.this.resetAxis(1);
                    if (!(GuiCreationParts.this.showEntity instanceof EntityCustomNpc) || GuiCreationParts.this.playerdata == null) break;
                    ((EntityCustomNpc)GuiCreationParts.this.showEntity).modelData.load(GuiCreationParts.this.playerdata.save());
                    break;
                }
                case 28: {
                    GuiCreationParts.this.resetAxis(2);
                    if (!(GuiCreationParts.this.showEntity instanceof EntityCustomNpc) || GuiCreationParts.this.playerdata == null) break;
                    ((EntityCustomNpc)GuiCreationParts.this.showEntity).modelData.load(GuiCreationParts.this.playerdata.save());
                    break;
                }
                case 29: {
                    LayerModel lm = GuiCreationParts.this.playerdata.getLayerModel(this.selectPos);
                    if (lm == null) {
                        return;
                    }
                    lm.part = this.partNames.get(((GuiNpcButton)btn).getValue());
                    if (!(GuiCreationParts.this.showEntity instanceof EntityCustomNpc) || GuiCreationParts.this.playerdata == null) break;
                    ((EntityCustomNpc)GuiCreationParts.this.showEntity).modelData.load(GuiCreationParts.this.playerdata.save());
                    break;
                }
                default: {
                    super.actionPerformed(btn);
                }
            }
        }

        @Override
        public int initGui() {
            int id;
            GuiNpcTextField.unfocus();
            this.parent.components.removeIf(component -> component.getID() != 66 && component.getID() != 500 && component.getID() > 19 || component instanceof GuiCustomScroll && component.getID() == 1);
            this.parent.field_146292_n.removeIf(button -> button.field_146127_k != 500 && button.field_146127_k > 19);
            Iterator iterator = new ArrayList(this.parent.buttons.keySet()).iterator();
            while (iterator.hasNext()) {
                id = (Integer)iterator.next();
                if ((id == 66 || id == 500 || id <= 19) && ((IGuiNpcButton)this.parent.buttons.get(id)).getID() != 1) continue;
                this.parent.buttons.remove(id);
            }
            iterator = new ArrayList(this.parent.labels.keySet()).iterator();
            while (iterator.hasNext()) {
                id = (Integer)iterator.next();
                if (id <= 19 && ((IGuiNpcLabel)this.parent.labels.get(id)).getID() != 1) continue;
                this.parent.labels.remove(id);
            }
            iterator = new ArrayList(this.parent.scrolls.keySet()).iterator();
            while (iterator.hasNext()) {
                id = (Integer)iterator.next();
                if (id <= 1 && ((IGuiCustomScroll)this.parent.scrolls.get(id)).getID() != 1) continue;
                this.parent.scrolls.remove(id);
            }
            int x0 = GuiCreationParts.this.field_147003_i + 123;
            int y = GuiCreationParts.this.field_147009_r;
            GuiCreationParts.this.addButton(new GuiNpcCheckBox(20, x0, y, 100, 20, "part.layers.true", "part.layers.false", this.isCustomLayers));
            ((GuiNpcCheckBox)GuiCreationParts.this.getButton(20)).setColor(CustomNpcs.MainColor.getRGB(), false);
            y += 25;
            if (this.isCustomLayers) {
                this.scrollIn = new GuiCustomScroll(this.parent, 1);
                this.scrollIn.setSize(100, 102);
                NBTTagCompound compound = new NBTTagCompound();
                LayerModel lm = GuiCreationParts.this.playerdata.getLayerModel(this.selectPos);
                if (lm == null) {
                    ItemStack stack = this.cont.func_75139_a(0).func_75211_c();
                    if (!stack.func_190926_b()) {
                        this.selectPos = GuiCreationParts.this.playerdata.addNewLayer();
                        lm = GuiCreationParts.this.playerdata.getLayerModel(this.selectPos);
                        lm.setStack(stack);
                        stack.func_77955_b(compound);
                    } else {
                        this.selectPos = -1;
                        ItemStack.field_190927_a.func_77955_b(compound);
                    }
                } else {
                    lm.getStack().func_77955_b(compound);
                }
                Client.sendData(EnumPacketServer.ChangeItemInSlot, "ContainerLayer", 0, compound);
                this.scrollIn.setListNotSorted(GuiCreationParts.this.playerdata.getLayerKeys());
                this.scrollIn.setSelect(this.selectPos);
                GuiCreationParts.this.addLabel(new GuiNpcLabel(20, "part.layers.info.0", x0, y));
                GuiCreationParts.this.getLabel(20).setColor(CustomNpcs.MainColor.getRGB());
                int y1 = y + 116;
                GuiNpcButton button2 = new GuiNpcButton(21, x0, y1, 49, 20, "gui.add");
                GuiCreationParts.this.addButton(button2);
                button2.setEnabled(GuiCreationParts.this.playerdata.isNoEmptyLayer());
                button2 = new GuiNpcButton(22, x0 + 51, y1, 49, 20, "gui.remove");
                GuiCreationParts.this.addButton(button2);
                button2.setEnabled(this.selectPos != -1);
                if (lm != null) {
                    int x1 = x0 + 104;
                    String objModel = lm.getOBJ() == null ? "" : lm.getOBJ().toString();
                    y1 = y - 21;
                    GuiCreationParts.this.addLabel(new GuiNpcLabel(19, "OBJ Model path:", x1 + 1, y1));
                    GuiCreationParts.this.getLabel(19).setColor(CustomNpcs.MainColor.getRGB());
                    GuiNpcTextField textField = new GuiNpcTextField(25, (GuiScreen)this.parent, x1, y1 += 12, 150, 16, objModel);
                    GuiCreationParts.this.addTextField(textField);
                    textField.setHoverText("display.hover.layer.obj", new Object[0]);
                    GuiCreationParts.this.addLabel(new GuiNpcLabel(22, "Tool type:", x1 + 1, (y1 += 19) + 2));
                    GuiCreationParts.this.getLabel(22).setColor(CustomNpcs.MainColor.getRGB());
                    if (!lm.getStack().func_190926_b() || lm.getOBJ() != null) {
                        button2 = new GuiNpcButton(23, x1 + 50, y1, 14, 14, "");
                        button2.texture = GuiNPCInterface.ANIMATION_BUTTONS;
                        button2.hasDefBack = false;
                        button2.isAnim = true;
                        button2.txrW = 24;
                        button2.txrH = 24;
                        button2.layerColor = GuiCreationParts.this.toolType == 1 ? new Color(-49088).getRGB() : new Color(-1).getRGB();
                        button2.setHoverText("animation.hover.tool.0", new Object[0]);
                        GuiCreationParts.this.addButton(button2);
                        button2 = new GuiNpcButton(24, x1 + 66, y1, 14, 14, "");
                        button2.texture = GuiNPCInterface.ANIMATION_BUTTONS;
                        button2.hasDefBack = false;
                        button2.isAnim = true;
                        button2.txrX = 24;
                        button2.txrW = 24;
                        button2.txrH = 24;
                        button2.layerColor = GuiCreationParts.this.toolType == 0 ? new Color(-12517568).getRGB() : new Color(-1).getRGB();
                        button2.setHoverText("animation.hover.tool.1", new Object[0]);
                        GuiCreationParts.this.addButton(button2);
                        button2 = new GuiNpcButton(25, x1 + 82, y1, 14, 14, "");
                        button2.texture = GuiNPCInterface.ANIMATION_BUTTONS;
                        button2.hasDefBack = false;
                        button2.isAnim = true;
                        button2.txrX = 48;
                        button2.txrW = 24;
                        button2.txrH = 24;
                        button2.layerColor = GuiCreationParts.this.toolType == 2 ? new Color(-12566273).getRGB() : new Color(-1).getRGB();
                        button2.setHoverText("animation.hover.tool.2", new Object[0]);
                        GuiCreationParts.this.addButton(button2);
                        int f = 11;
                        y1 += 16;
                        for (int i = 0; i < 3; ++i) {
                            float max;
                            float min;
                            float s;
                            float v;
                            int id2 = i + 26;
                            GuiCreationParts.this.addLabel(new GuiNpcLabel(id2, i == 0 ? "X:" : (i == 1 ? "Y:" : "Z:"), x1 + 1, y1 + i * f));
                            GuiCreationParts.this.getLabel(id2).setColor(CustomNpcs.MainColor.getRGB());
                            switch (GuiCreationParts.this.toolType) {
                                case 0: {
                                    v = lm.rotation[i];
                                    s = 0.002778f * lm.rotation[i] + 0.5f;
                                    min = -180.0f;
                                    max = 180.0f;
                                    break;
                                }
                                case 1: {
                                    v = lm.offset[i];
                                    s = 0.2f * lm.offset[i] + 0.5f;
                                    min = -10.0f;
                                    max = 10.0f;
                                    break;
                                }
                                default: {
                                    v = lm.scale[i];
                                    s = 0.2f * lm.scale[i];
                                    min = 0.0f;
                                    max = 5.0f;
                                }
                            }
                            GuiNpcSlider slider = new GuiNpcSlider(this.parent, id2, x1 + 9, y1 + i * f, 78, 8, s);
                            String hover = "animation.hover." + (GuiCreationParts.this.toolType == 0 ? "rotation" : (GuiCreationParts.this.toolType == 1 ? "offset" : "scale"));
                            slider.setHoverText(hover, i == 0 ? "X" : (i == 1 ? "Y" : "Z"));
                            GuiCreationParts.this.addSlider(slider);
                            textField = new GuiNpcTextField(id2, (GuiScreen)this.parent, x1 + 89, y1 + i * f, 42, 8, df.format(v));
                            textField.setMinMaxDoubleDefault(min, max, v);
                            textField.setHoverText(hover, i == 0 ? "X" : (i == 1 ? "Y" : "Z"));
                            GuiCreationParts.this.addTextField(textField);
                            button2 = new GuiNpcButton(id2, x1 + 133, y1 + i * f, 8, 8, "X");
                            button2.texture = GuiNPCInterface.ANIMATION_BUTTONS;
                            button2.hasDefBack = false;
                            button2.isAnim = true;
                            button2.txrY = 96;
                            button2.dropShadow = false;
                            button2.setTextColor(-2359296);
                            button2.setHoverText("animation.hover.reset." + GuiCreationParts.this.toolType, i == 0 ? "X" : (i == 1 ? "Y" : "Z"));
                            GuiCreationParts.this.addButton(button2);
                        }
                        y1 += f * 3 + 2;
                    }
                    int pos = 0;
                    String[] names = new String[this.partNames.size()];
                    for (int i : this.partNames.keySet()) {
                        if (this.partNames.get(i) == lm.part) {
                            pos = i;
                        }
                        names[i] = "part." + this.partNames.get((Object)Integer.valueOf((int)i)).name;
                    }
                    button2 = new GuiButtonBiDirectional(29, x1, y1, 78, 14, names, pos);
                    GuiCreationParts.this.addButton(button2);
                    button2.setHoverText("display.hover.layer.type", new Object[0]);
                }
            } else {
                this.scrollIn = new GuiCustomScroll((ICustomScrollListener)this.parent, 1, true);
                this.scrollIn.setSize(120, 175);
                this.scrollIn.canSearch(false);
                GuiCreationParts.this.addLabel(new GuiNpcLabel(20, "part.layers.info.1", x0, y));
                GuiCreationParts.this.getLabel(20).setColor(CustomNpcs.MainColor.getRGB());
                Render render = GuiCreationParts.this.field_146297_k.func_175598_ae().func_78713_a((Entity)GuiCreationParts.this.npc);
                if (render instanceof RenderCustomNpc) {
                    this.scrollIn.setList(((RenderCustomNpc)render).getLayerRendererNames());
                }
                this.scrollIn.setSelectedList(new HashSet<String>(Arrays.asList(GuiCreationParts.this.playerdata.getDisableLayers())));
            }
            this.scrollIn.guiLeft = x0;
            this.scrollIn.guiTop = y += 12;
            GuiCreationParts.this.addScroll(this.scrollIn);
            if (GuiCreationParts.this.showEntity instanceof EntityCustomNpc && GuiCreationParts.this.playerdata != null) {
                ((EntityCustomNpc)GuiCreationParts.this.showEntity).modelData.load(GuiCreationParts.this.playerdata.save());
            }
            return y;
        }
    }

    class GuiPartWings
    extends GuiPart {
        public GuiPartWings() {
            super(EnumParts.WINGS);
            this.setTypes(new String[]{"gui.none", "1", "2", "3", "4"});
        }

        @Override
        public int initGui() {
            return super.initGui();
        }
    }

    class GuiPartTail
    extends GuiPart {
        public GuiPartTail() {
            super(EnumParts.TAIL);
            this.types = new String[]{"gui.none", "part.tail", "tail.dragon", "tail.horse", "tail.squirrel", "tail.fin", "tail.rodent", "tail.bird", "tail.fox"};
        }

        @Override
        public int initGui() {
            this.data = GuiCreationParts.this.playerdata.getPartData(this.part);
            this.hasPlayerOption = this.data != null && (this.data.type == 0 || this.data.type == 1 || this.data.type == 6 || this.data.type == 7);
            int y = super.initGui();
            if (this.data != null && this.data.type == 0) {
                GuiCreationParts.this.addLabel(new GuiNpcLabel(22, "gui.pattern", GuiCreationParts.this.field_147003_i + 123, y + 5, 0xFFFFFF));
                GuiCreationParts.this.addButton(new GuiButtonBiDirectional(22, GuiCreationParts.this.field_147003_i + 175, y, 100, 20, new String[]{"1", "2"}, this.data.pattern));
            }
            return y;
        }
    }

    class GuiPartSnout
    extends GuiPart {
        public GuiPartSnout() {
            super(EnumParts.SNOUT);
            this.types = new String[]{"gui.none", "snout.small", "snout.medium", "snout.large", "snout.bunny", "snout.beak"};
        }
    }

    class GuiPartParticles
    extends GuiPart {
        public GuiPartParticles() {
            super(EnumParts.PARTICLES);
            this.types = new String[]{"gui.none", "1", "2"};
        }

        @Override
        public int initGui() {
            return super.initGui();
        }
    }

    class GuiPartLegs
    extends GuiPart {
        public GuiPartLegs() {
            super(EnumParts.LEGS);
            this.types = new String[]{"gui.none", "gui.normal", "legs.naga", "legs.spider", "legs.horse", "legs.mermaid", "legs.digitigrade"};
            this.canBeDeleted = false;
        }

        @Override
        protected void actionPerformed(GuiButton btn) {
            if (btn.field_146127_k == 20) {
                int i = ((GuiNpcButton)btn).getValue();
                this.data.playerTexture = i <= 1;
            }
            super.actionPerformed(btn);
        }

        @Override
        public int initGui() {
            this.hasPlayerOption = this.data.type == 1 || this.data.type == 5;
            return super.initGui();
        }
    }

    class GuiPartHorns
    extends GuiPart {
        public GuiPartHorns() {
            super(EnumParts.HORNS);
            this.types = new String[]{"gui.none", "horns.bull", "horns.antlers", "horns.antenna"};
        }

        @Override
        public int initGui() {
            int y = super.initGui();
            if (this.data != null && this.data.type == 2) {
                GuiCreationParts.this.addLabel(new GuiNpcLabel(22, "gui.pattern", GuiCreationParts.this.field_147003_i + 123, y + 5, 0xFFFFFF));
                GuiCreationParts.this.addButton(new GuiButtonBiDirectional(22, GuiCreationParts.this.field_147003_i + 175, y, 100, 20, new String[]{"1", "2"}, this.data.pattern));
            }
            return y;
        }
    }

    class GuiPartHair
    extends GuiPart {
        public GuiPartHair() {
            super(EnumParts.HAIR);
            this.noPlayerTypes().types = new String[]{"gui.none", "1", "2", "3", "4"};
        }
    }

    class GuiPartEyes
    extends GuiPart {
        private final ModelEyeData eyes;

        public GuiPartEyes() {
            super(EnumParts.EYES);
            this.types = new String[]{"gui.none", "gui.small", "gui.normal", "gui.select"};
            this.noPlayerOptions();
            this.canBeDeleted = false;
            this.eyes = (ModelEyeData)this.data;
        }

        @Override
        protected void actionPerformed(GuiButton btn) {
            switch (btn.field_146127_k) {
                case 23: {
                    GuiCreationParts.this.setSubGui(new GuiModelColor((GuiScreen)GuiCreationParts.this, this.eyes.eyeColor[1], color -> {
                        this.eyes.eyeColor[1] = color;
                    }));
                    break;
                }
                case 24: {
                    GuiCreationParts.this.setSubGui(new GuiModelColor((GuiScreen)GuiCreationParts.this, this.eyes.eyeColor[0], color -> {
                        this.eyes.eyeColor[0] = color;
                    }));
                    break;
                }
                case 25: {
                    GuiCreationParts.this.setSubGui(new GuiModelColor((GuiScreen)GuiCreationParts.this, this.eyes.pupilColor[0], color -> {
                        this.eyes.pupilColor[0] = color;
                    }));
                    break;
                }
                case 26: {
                    GuiCreationParts.this.setSubGui(new GuiModelColor((GuiScreen)GuiCreationParts.this, this.eyes.pupilColor[1], color -> {
                        this.eyes.pupilColor[1] = color;
                    }));
                    break;
                }
                case 27: {
                    GuiCreationParts.this.setSubGui(new GuiModelColor((GuiScreen)GuiCreationParts.this, this.eyes.browColor[1], color -> {
                        this.eyes.browColor[1] = color;
                    }));
                    break;
                }
                case 28: {
                    GuiCreationParts.this.setSubGui(new GuiModelColor((GuiScreen)GuiCreationParts.this, this.eyes.browColor[0], color -> {
                        this.eyes.browColor[0] = color;
                    }));
                    break;
                }
                case 29: {
                    this.eyes.browThickness = ((GuiNpcButton)btn).getValue();
                    break;
                }
                case 30: {
                    GuiCreationParts.this.setSubGui(new GuiModelColor((GuiScreen)GuiCreationParts.this, this.eyes.skinColor, color -> {
                        this.eyes.skinColor = color;
                    }));
                    break;
                }
                case 31: {
                    this.eyes.closed = ((GuiNpcButton)btn).getValue();
                    break;
                }
                case 32: {
                    this.eyes.eyePos = ((GuiNpcButton)btn).getValue() - 1;
                    break;
                }
                case 33: {
                    this.eyes.glint = ((GuiNpcButtonYesNo)btn).getBoolean();
                    break;
                }
                case 34: {
                    GuiCreationParts.this.setSubGui(new GuiTextureSelection(0, null, this.eyes.eyeRight.toString(), "png", 5));
                    break;
                }
                case 35: {
                    GuiCreationParts.this.setSubGui(new GuiTextureSelection(1, null, this.eyes.eyeLeft.toString(), "png", 5));
                    break;
                }
                case 36: {
                    GuiCreationParts.this.setSubGui(new GuiTextureSelection(2, null, this.eyes.pupilRight.toString(), "png", 5));
                    break;
                }
                case 37: {
                    GuiCreationParts.this.setSubGui(new GuiTextureSelection(3, null, this.eyes.pupilLeft.toString(), "png", 5));
                    break;
                }
                case 38: {
                    GuiCreationParts.this.setSubGui(new GuiTextureSelection(4, null, this.eyes.browRight.toString(), "png", 5));
                    break;
                }
                case 39: {
                    GuiCreationParts.this.setSubGui(new GuiTextureSelection(5, null, this.eyes.browLeft.toString(), "png", 5));
                    break;
                }
                case 40: {
                    this.eyes.reset();
                    this.initGui();
                    break;
                }
                case 41: {
                    this.eyes.activeRight = ((GuiNpcButtonYesNo)btn).getBoolean();
                    break;
                }
                case 42: {
                    this.eyes.activeLeft = ((GuiNpcButtonYesNo)btn).getBoolean();
                    break;
                }
                case 43: {
                    this.eyes.activeCenter = ((GuiNpcButtonYesNo)btn).getBoolean();
                    break;
                }
                case 44: {
                    GuiCreationParts.this.setSubGui(new GuiModelColor((GuiScreen)GuiCreationParts.this, this.eyes.centerColor, color -> {
                        this.eyes.centerColor = color;
                    }));
                    break;
                }
                case 45: {
                    GuiCreationParts.this.setSubGui(new GuiModelColor((GuiScreen)GuiCreationParts.this, this.eyes.eyeColor[0], color -> {
                        this.eyes.eyeColor[0] = color;
                        this.eyes.eyeColor[1] = color;
                    }));
                    break;
                }
                case 46: {
                    GuiCreationParts.this.setSubGui(new GuiModelColor((GuiScreen)GuiCreationParts.this, this.eyes.pupilColor[0], color -> {
                        this.eyes.pupilColor[0] = color;
                        this.eyes.pupilColor[1] = color;
                    }));
                    break;
                }
                case 47: {
                    GuiCreationParts.this.setSubGui(new GuiModelColor((GuiScreen)GuiCreationParts.this, this.eyes.browColor[0], color -> {
                        this.eyes.browColor[0] = color;
                        this.eyes.browColor[1] = color;
                    }));
                    break;
                }
                default: {
                    super.actionPerformed(btn);
                }
            }
        }

        @Override
        public int initGui() {
            int y = super.initGui();
            if (this.data != null && this.eyes.isEnabled()) {
                int x0 = GuiCreationParts.this.field_147003_i + 123;
                int x1 = GuiCreationParts.this.field_147003_i + 175;
                y = GuiCreationParts.this.field_147009_r + 50;
                GuiNpcLabel label = (GuiNpcLabel)GuiCreationParts.this.getLabel(20);
                GuiNpcButton button = (GuiNpcButton)GuiCreationParts.this.getButton(20);
                label.y = y + 3;
                button.field_146128_h = x1;
                button.field_146129_i = y;
                button.field_146121_g = 14;
                if (this.eyes.type != -1) {
                    GuiCreationParts.this.addButton(new GuiNpcButton(40, x1 + 104, y, 31, 14, "RND"));
                }
                label = (GuiNpcLabel)GuiCreationParts.this.getLabel(23);
                button = (GuiNpcButton)GuiCreationParts.this.getButton(23);
                label.setLabel("eye.color.0");
                label.y = (y += 16) + 3;
                button.field_146129_i = y;
                button.field_146128_h = x1;
                button.field_146121_g = 14;
                button.field_146120_f = 40;
                ((GuiColorButton)button).color = this.eyes.eyeColor[1];
                GuiCreationParts.this.addButton(new GuiNpcButton(45, x1 + 42, y, 18, 14, "-"));
                GuiCreationParts.this.addButton(new GuiColorButton(24, x1 + 62, y, 40, 14, this.eyes.eyeColor[0]));
                if (this.data.type == 2) {
                    GuiCreationParts.this.addButton(new GuiNpcButton(34, x1 + 104, y, 14, 14, "EL"));
                    GuiCreationParts.this.addButton(new GuiNpcButton(35, x1 + 120, y, 14, 14, "ER"));
                }
                GuiCreationParts.this.addLabel(new GuiNpcLabel(25, "eye.color.1", x0, (y += 16) + 3, 0xFFFFFF));
                button = new GuiColorButton(25, x1, y, 40, 14, this.eyes.pupilColor[0]);
                GuiCreationParts.this.addButton(button);
                GuiCreationParts.this.addButton(new GuiNpcButton(46, x1 + 42, y, 18, 14, "-"));
                GuiCreationParts.this.addButton(new GuiColorButton(26, x1 + 62, y, 40, 14, this.eyes.pupilColor[1]));
                if (this.data.type == 2) {
                    GuiCreationParts.this.addButton(new GuiNpcButton(36, x1 + 104, y, 14, 14, "PL"));
                    GuiCreationParts.this.addButton(new GuiNpcButton(37, x1 + 120, y, 14, 14, "PR"));
                }
                GuiCreationParts.this.addLabel(new GuiNpcLabel(44, "eye.color.2", x0, (y += 16) + 3, 0xFFFFFF));
                button = new GuiColorButton(44, x1, y, 102, 14, this.eyes.centerColor);
                GuiCreationParts.this.addButton(button);
                button = new GuiNpcButtonYesNo(43, x1 + 104, y, 20, 14, this.eyes.activeCenter);
                GuiCreationParts.this.addButton(button);
                GuiCreationParts.this.addLabel(new GuiNpcLabel(27, "eye.color.3", x0, (y += 16) + 3, 0xFFFFFF));
                button = new GuiColorButton(27, x1 + 62, y, 40, 14, this.eyes.browColor[1]);
                GuiCreationParts.this.addButton(button);
                GuiCreationParts.this.addButton(new GuiNpcButton(47, x1 + 42, y, 18, 14, "-"));
                GuiCreationParts.this.addButton(new GuiColorButton(28, x1, y, 40, 14, this.eyes.browColor[0]));
                if (this.data.type == 2) {
                    GuiCreationParts.this.addButton(new GuiNpcButton(38, x1 + 104, y, 14, 14, "BL"));
                    GuiCreationParts.this.addButton(new GuiNpcButton(39, x1 + 120, y, 14, 14, "BR"));
                }
                GuiCreationParts.this.addLabel(new GuiNpcLabel(29, "eye.brow", x0, (y += 16) + 3, 0xFFFFFF));
                GuiCreationParts.this.addButton(new GuiNpcButton(29, x1, y, 102, 14, new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8"}, this.eyes.browThickness));
                GuiCreationParts.this.addLabel(new GuiNpcLabel(30, "eye.lid", x0, (y += 16) + 3, 0xFFFFFF));
                button = new GuiColorButton(30, x1, y, this.eyes.skinColor);
                button.field_146120_f = 100;
                button.field_146121_g = 14;
                GuiCreationParts.this.addButton(button);
                GuiCreationParts.this.addLabel(new GuiNpcLabel(22, "gui.draw", x0, (y += 16) + 3, 0xFFFFFF));
                GuiCreationParts.this.addButton(new GuiNpcButton(22, x1, y, 102, 14, new String[]{"gui.both", "gui.left", "gui.right"}, this.data.pattern));
                GuiCreationParts.this.addLabel(new GuiNpcLabel(31, "eye.closed", x0, (y += 16) + 3, 0xFFFFFF));
                button = new GuiNpcButton(31, x1, y, 102, 14, new String[]{"gui.none", "gui.both", "gui.left", "gui.right"}, this.eyes.closed);
                GuiCreationParts.this.addButton(button);
                button = new GuiNpcButtonYesNo(41, x1 + 104, y, 20, 14, this.eyes.activeRight);
                GuiCreationParts.this.addButton(button);
                button = new GuiNpcButtonYesNo(42, x1 + 126, y, 20, 14, this.eyes.activeLeft);
                GuiCreationParts.this.addButton(button);
                GuiCreationParts.this.addLabel(new GuiNpcLabel(32, "gui.position", x0, (y += 16) + 3, 0xFFFFFF));
                GuiCreationParts.this.addButton(new GuiNpcButton(32, x1, y, 102, 14, new String[]{new TextComponentTranslation("gui.down", new Object[0]).func_150254_d() + " x2", "gui.down", "gui.normal", "gui.up", new TextComponentTranslation("gui.up", new Object[0]).func_150254_d() + " x2"}, this.eyes.eyePos + 1));
                GuiCreationParts.this.addLabel(new GuiNpcLabel(33, "eye.glint", x0, (y += 16) + 3, 0xFFFFFF));
                button = new GuiNpcButtonYesNo(33, x1, y, 102, 14, this.eyes.glint);
                GuiCreationParts.this.addButton(button);
            }
            return y;
        }

        @Override
        public void subGuiClosed(SubGuiInterface subgui) {
            if (subgui instanceof GuiTextureSelection) {
                GuiTextureSelection tGui = (GuiTextureSelection)subgui;
                if (subgui.getId() == 0) {
                    this.eyes.eyeRight = tGui.resource;
                } else if (subgui.getId() == 1) {
                    this.eyes.eyeLeft = tGui.resource;
                } else if (subgui.getId() == 2) {
                    this.eyes.pupilRight = tGui.resource;
                } else if (subgui.getId() == 3) {
                    this.eyes.pupilLeft = tGui.resource;
                } else if (subgui.getId() == 4) {
                    this.eyes.browRight = tGui.resource;
                } else if (subgui.getId() == 5) {
                    this.eyes.browLeft = tGui.resource;
                }
            }
        }
    }

    class GuiPartClaws
    extends GuiPart {
        public GuiPartClaws() {
            super(EnumParts.CLAWS);
            this.types = new String[]{"gui.none", "gui.show"};
        }

        @Override
        public int initGui() {
            int y = super.initGui();
            if (this.data == null) {
                return y;
            }
            GuiCreationParts.this.addLabel(new GuiNpcLabel(22, "gui.pattern", GuiCreationParts.this.field_147003_i + 123, y + 5, 0xFFFFFF));
            GuiCreationParts.this.addButton(new GuiButtonBiDirectional(22, GuiCreationParts.this.field_147003_i + 175, y, 100, 20, new String[]{"gui.both", "gui.left", "gui.right"}, this.data.pattern));
            return y;
        }
    }

    class GuiPartBeard
    extends GuiPart {
        public GuiPartBeard() {
            super(EnumParts.BEARD);
            this.noPlayerTypes().types = new String[]{"gui.none", "1", "2", "3", "4"};
        }
    }

    public class GuiPart
    implements ISubGuiListener {
        protected boolean canBeDeleted = true;
        protected ModelPartData data;
        protected boolean hasPlayerOption = true;
        protected boolean noPlayerTypes = false;
        EnumParts part;
        public int patterns = 0;
        protected String[] types = new String[]{"gui.none"};

        public GuiPart(EnumParts part) {
            this.part = part;
            this.data = GuiCreationParts.this.playerdata.getPartData(part);
        }

        protected void actionPerformed(GuiButton btn) {
            if (btn.field_146127_k == 20) {
                int i = ((GuiNpcButton)btn).getValue();
                if (i == 0 && this.canBeDeleted) {
                    GuiCreationParts.this.playerdata.removePart(this.part);
                } else {
                    this.data = GuiCreationParts.this.playerdata.getOrCreatePart(this.part);
                    this.data.pattern = 0;
                    this.data.setType(i - 1);
                }
                this.initGui();
            }
            if (btn.field_146127_k == 22) {
                this.data.pattern = (byte)((GuiNpcButton)btn).getValue();
            }
            if (btn.field_146127_k == 21) {
                this.data.playerTexture = ((GuiNpcButtonYesNo)btn).getBoolean();
                this.initGui();
            }
            if (btn.field_146127_k == 23) {
                GuiCreationParts.this.setSubGui(new GuiModelColor((GuiScreen)GuiCreationParts.this, this.data.color, color -> {
                    this.data.color = color;
                }));
            }
        }

        public int initGui() {
            this.data = GuiCreationParts.this.playerdata.getPartData(this.part);
            int x0 = GuiCreationParts.this.field_147003_i + 123;
            int x1 = GuiCreationParts.this.field_147003_i + 175;
            int y = GuiCreationParts.this.field_147009_r + 50;
            if (this.data == null || !this.data.playerTexture || !this.noPlayerTypes) {
                GuiCreationParts.this.addLabel(new GuiNpcLabel(20, "gui.type", x0, y + 5, 0xFFFFFF));
                GuiCreationParts.this.addButton(new GuiButtonBiDirectional(20, x1, y, 100, 20, this.types, this.data == null ? 0 : this.data.type + 1));
                y += 25;
            }
            if (this.data != null && this.hasPlayerOption) {
                GuiCreationParts.this.addLabel(new GuiNpcLabel(21, "gui.playerskin", x0, y + 5, 0xFFFFFF));
                GuiCreationParts.this.addButton(new GuiNpcButtonYesNo(21, x1, y, this.data.playerTexture));
                y += 25;
            }
            if (this.data != null && !this.data.playerTexture) {
                GuiCreationParts.this.addLabel(new GuiNpcLabel(23, "gui.color", x0, y + 5, 0xFFFFFF));
                GuiCreationParts.this.addButton(new GuiColorButton(23, x1, y, this.data.color));
                y += 25;
            }
            return y;
        }

        public GuiPart noPlayerOptions() {
            this.hasPlayerOption = false;
            return this;
        }

        public GuiPart noPlayerTypes() {
            this.noPlayerTypes = true;
            return this;
        }

        public GuiPart setTypes(String[] typesIn) {
            this.types = typesIn;
            return this;
        }

        @Override
        public void subGuiClosed(SubGuiInterface subgui) {
        }
    }
}

